package gov.va.vamf.scheduling.communitycare.domain;


import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;
import com.agilex.healthcare.veteranappointment.serializer.JsonDateSerializer;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlRootElement;

import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;
import java.io.Serializable;

@Document(collection="bookedCCAppointments")
@XmlRootElement(name = "bookedCCAppointment")
@XmlAccessorType(value = XmlAccessType.NONE)
public class BookedCCAppointment implements Serializable{
	private static final long serialVersionUID = -2583575242661822139L;

	@Id
	@XmlElement
	private String appointmentRequestId;

	// PatientIdentifier is from HealthAdapterLib and at this point only contains AssigningAuthority and UniqueId
	// which are the ONLY two fields we want to persist.
	@XmlElement
	private PatientIdentifier patientIdentifier;
	
	@XmlElement
	private boolean distanceEligibleConfirmed;

	@XmlElement
	private Name name;

	@XmlElement
	private String providerPractice;

	@XmlElement
	private String providerPhone;

	@XmlElement
	private FormAddress address;

	@XmlElement
	private String instructionsToVeteran;

	@Field("dateTime")
	@XmlElement
	@JsonSerialize(using = JsonDateSerializer.class)
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "MM/dd/yyyy HH:mm:ss")
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date appointmentTime;

	@XmlElement
	private String timeZone;

	public String getAppointmentRequestId() {
		return appointmentRequestId;
	}

	public void setAppointmentRequestId(String appointmentRequestId) {
		this.appointmentRequestId = appointmentRequestId;
	}

	public PatientIdentifier getPatientIdentifier() {
		return patientIdentifier;
	}

	public void setPatientIdentifier(PatientIdentifier patientIdentifier) {
		this.patientIdentifier = patientIdentifier;
	}

	public boolean isDistanceEligibleConfirmed() {
		return distanceEligibleConfirmed;
	}

	public void setDistanceEligibleConfirmed(boolean distanceEligibleConfirmed) {
		this.distanceEligibleConfirmed = distanceEligibleConfirmed;
	}

	public String getProviderPractice() {
		return providerPractice;
	}

	public void setProviderPractice(String providerPractice) {
		this.providerPractice = providerPractice;
	}

	public String getProviderPhone() {
		return providerPhone;
	}

	public void setProviderPhone(String providerPhone) {
		this.providerPhone = providerPhone;
	}

	public String getInstructionsToVeteran() {
		return instructionsToVeteran;
	}

	public void setInstructionsToVeteran(String instructionsToVeteran) {
		this.instructionsToVeteran = instructionsToVeteran;
	}

	public Name getName() {
		return name;
	}

	public void setName(Name name) {
		this.name = name;
	}

	public FormAddress getAddress() {
		return address;
	}

	public void setAddress(FormAddress address) {
		this.address = address;
	}

	public Date getAppointmentTime() {
		return appointmentTime;
	}

	public void setAppointmentTime(Date dateTime) {
		this.appointmentTime = dateTime;
	}

	public String getTimeZone() {
		return timeZone;
	}

	public void setTimeZone(String timeZone) {
		this.timeZone = timeZone;
	}



}